require( "scripts/style.lua" );

kScoreRowSpace = 25;
kRowY = 75;
kNumberX = 37;
kXOff = 20;
kNameX = 72;
kScoreX = 335;
kP1X = kNumberX + 21;

kNameW = 250
kNameH = 21

eLocalView=0;
eRequestingCategories=1;
eRequestingScores=2;
eSubmitting=3;
eGlobalView=4;
eError=5;

function UpdateButtons()
    local state = GetState();
    local localHS = IsEnabled(kHiscoreLocalOnly);
    local anonHS = IsEnabled(kHiscoreAnonymous);
    local fullHS = (not localHS) and (not anonHS);

    EnableWindow("view",false);
    EnableWindow("viewlocal",false);
    EnableWindow("submit",false);
    EnableWindow("categoryleft",false);
    EnableWindow("categoryright",false);

    if (state==eLocalView) then
        local eligibleScore;

        if fullHS then
            EnableWindow("moreinfo",true);
        else 
            EnableWindow("moreinfo",false);
        end

        if not localHS then
            EnableWindow("view",true);

            if (ScoreAvailable()) then
                EnableWindow("submit",true);
            end
        end
    elseif (state == eGlobalView) then
        EnableWindow("viewlocal",true);
        EnableWindow("categoryleft",true);
        EnableWindow("categoryright",true);
    elseif (state == eError) then
        EnableWindow("viewlocal",true);
    end

end


MakeDialog
{
    -- Name the modal dialog
    name="hiscorescreen",
    Bitmap
    {
        image="hiscore/highscore_background",

        HiscoreWindow
        {
            x=0,y=0,h=kMax,w=kMax,
            
            SetStyle(CreateTextStyle(FontGame, 54, BlackColor)),
            Text
            {
                name = "header",
                x=0,y=16,
                flags = kHAlignCenter + kVAlignTop,
                label = "highscoreheader"
            };

            SetStyle(CreateTextStyle(FontGame, 36, BlackColor)),
            Text
            {
                name = "gamemode",
                x=0,y=80,
                flags = kHAlignCenter + kVAlignTop,
                label = "#GAMEMODE"
            };

            Bitmap
            {
                x = 50,
                y = 135,
                w=440,h=430,
                --image="hiscore/global-hs-bb_large",
                name="leftpanel",

                SetStyle(CreateTextStyle(FontGame, 24, BlackColor)),
                Text
                {
                    name = "local",
                    x=26,y=12,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "localhighscores"
                };

                SetStyle(CreateTextStyle(FontGame, 24, BlackColor)),
                Text
                {
                    name = "global",
                    x=26,y=12,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "globalhighscores"
                };

                SetStyle(CreateTextStyle(FontGame, 24, BlackColor)),
                Text
                {
                    name = "topplayers",
                    x=26,y=12,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "topplayers"
                };

                SetStyle(CreateTextStyle(FontGame, 20, BlackColor)),
                -- all scores have one style
                Text
                {
                    name = "1",
                    x=kXOff,y=kRowY,w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "1."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_1",
                    x=kP1X,y=kRowY
                };

                Text
                {
                    name = "name1",
                    x=kNameX,y=kRowY,w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    name = "score1",
                    x=kXOff,y=kRowY,w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    name = "2",
                    x=kXOff,y=kRowY+(1*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "2."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_2",
                    x=kP1X,y=kRowY+(1*kScoreRowSpace)
                };

                Text
                {
                    name = "name2",
                    x=kNameX,y=kRowY+(1*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    name = "score2",
                    x=kXOff,y=kRowY+(1*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    name = "3",
                    x=kXOff,y=kRowY+(2*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "3."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_3",
                    x=kP1X,y=kRowY+(2*kScoreRowSpace)
                };

                Text
                {
                    name = "name3",
                    x=kNameX,y=kRowY+(2*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    name = "score3",
                    x=kXOff,y=kRowY+(2*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    name = "4",
                    x=kXOff,y=kRowY+(3*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "4."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_4",
                    x=kP1X,y=kRowY+(3*kScoreRowSpace)
                };

                Text
                {
                    name = "name4",
                    x=kNameX,y=kRowY+(3*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    name = "score4",
                    x=kXOff,y=kRowY+(3*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    name = "5",
                    x=kXOff,y=kRowY+(4*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "5."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_5",
                    x=kP1X,y=kRowY+(4*kScoreRowSpace)
                };

                Text
                {
                    name = "name5",
                    x=kNameX,y=kRowY+(4*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    name = "score5",
                    x=kXOff,y=kRowY+(4*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    name = "6",
                    x=kXOff,y=kRowY+(5*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "6."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_6",
                    x=kP1X,y=kRowY+(5*kScoreRowSpace)
                };

                Text
                {
                    name = "name6",
                    x=kNameX,y=kRowY+(5*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    name = "score6",
                    x=kXOff,y=kRowY+(5*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    name = "7",
                    x=kXOff,y=kRowY+(6*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "7."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_7",
                    x=kP1X,y=kRowY+(6*kScoreRowSpace)
                };

                Text
                {
                    name = "name7",
                    x=kNameX,y=kRowY+(6*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    name = "score7",
                    x=kXOff,y=kRowY+(6*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    name = "8",
                    x=kXOff,y=kRowY+(7*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "8."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_8",
                    x=kP1X,y=kRowY+(7*kScoreRowSpace)
                };

                Text
                {
                    name = "name8",
                    x=kNameX,y=kRowY+(7*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    name = "score8",
                    x=kXOff,y=kRowY+(7*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    name = "9",
                    x=kXOff,y=kRowY+(8*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "9."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_9",
                    x=kP1X,y=kRowY+(8*kScoreRowSpace)
                };

                Text
                {
                    name = "name9",
                    x=kNameX,y=kRowY+(8*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    name = "score9",
                    x=kXOff,y=kRowY+(8*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };

                Text
                {
                    name = "10",
                    x=kXOff,y=kRowY+(9*kScoreRowSpace),w=kNumberX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "10."
                };

                Bitmap
                {
                    image = "hiscore/p1icon",
                    name = "p1_10",
                    x=kP1X,y=kRowY+(9*kScoreRowSpace)
                };

                Text
                {
                    name = "name10",
                    x=kNameX,y=kRowY+(9*kScoreRowSpace),w=kNameW,h=kNameH,
                    flags = kHAlignLeft + kVAlignCenter,
                    label = "#name"
                };

                Text
                {
                    name = "score10",
                    x=kXOff,y=kRowY+(9*kScoreRowSpace),w=kScoreX,h=kMax,
                    flags = kHAlignRight + kVAlignTop,
                    label = "12345"
                };
            };

            Bitmap
            {
                x = 466,
                y = 135,
                w=290,h=430,
                --image="hiscore/local-hs-bb",
                name="rightpanelsmall",

                SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                Text
                {
                    name = "yourrankglobalinfo",
                    x=40,y=0,w=kMax-40,h=kMax,
                    label = "globalhighscoreinfo"
                };

                SetStyle(CreateTextStyle(FontGame, 26, BlackColor)),
                Text
                {
                    name = "yourrank",
                    x=20,y=15,w=kMax-20,h=kMax,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "yourrank"
                };

                SetStyle(CreateTextStyle(FontGame, 26, BlackColor)),
                Text
                {
                    name = "congratulations",
                    x=20,y=50,w=kMax-20,h=kMax,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "congratshighscore"
                };

                SetStyle(CreateTextStyle(FontGame, 26, BlackColor)),
                Text
                {
                    name = "dnq",
                    x=20,y=50,w=kMax-20,h=kMax,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "scorednq"
                };
            },


            Bitmap
            {
                x = 466,
                y = 135,
                w=290,h=430,
                --image="hiscore/local-hs-bb",
                name="rightpanel",

                SetStyle(CreateTextStyle(FontGame, 24, BlackColor)),
                Text
                {
                    name = "globalinfoheader",
                    x=20,y=12,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "globalhighscores"
                };

                SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                Text
                {
                    name = "info",
                    x=40,y=55,w=kMax-40,h=kMax,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "globalhighscoreinfo"
                };

                SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                Text
                {
                    name = "eligible",
                    x=60,y=180,w=kMax-60,h=kMax,
                    flags = kHAlignCenter + kVAlignTop,
                    label = "eligible"
                };

                SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
                Button
                {
                    x=kCenter,
                    y=kMax-100,
                    name="moreinfo",
                    command =
                        function()
                            DoModal("scripts/hiscoreinfo.lua");
                        end,
                    SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
                    CreateText(2,2,"moreinfo", 0, 0),
                    SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
                    CreateText(0,0,"moreinfo", 0, 0),
                };

                SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
                Button
                {
                    x=kCenter,
                    y=kMax-145,
                    name="submit",
                    SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
                    CreateText(2,2,"submit", 0, 0),
                    SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
                    CreateText(0,0,"submit", 0, 0),
                };
            };

--[[
            SetStyle(CreateTextStyle(FontGame, 12, BlackColor)),
            Text
            {
                name = "eligibleasterisk",
                x=490,y=510,w=kMax-20,h=kMax,
                flags = kHAlignLeft + kVAlignTop,
                label = "eligibleasterisk",
                padding=0
            };
--]]

            SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
            Text
            {
                name = "server",
                x=500,y=362,w=220,h=130,
                flags = kHAlignCenter + kVAlignTop,
                label = "connectingtoserver"
            };
            
            SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
            Text
            {
                name = "error",
                x=500,y=362,w=220,h=130,
                flags = kHAlignCenter + kVAlignTop,
            };


            SetStyle(CreateTextStyle(FontGame, 20, BlackColor)),
            Text
            {
                name = "category",
                x=163,y=184,w=208,h=40,
                flags = kHAlignCenter + kVAlignTop,
            };

            SetStyle(CreatePushButtonStyle(LeftArrowButtonGraphics, DefaultButtonSound)),
            Button
            {
                name="gamemodeleft",
                x=250,
                y=74,
            };

            SetStyle(CreatePushButtonStyle(LeftArrowButtonGraphics, DefaultButtonSound)),
            Button
            {
                name="gamemoderight",
                x=510,
                y=74,
                hflip=true,
            };

            Button
            {
                name="categoryleft",
                x=160,
                y=178,
                scale = 0.6
            };

            
            Button
            {
                name="categoryright",
                x=330,
                y=178,
                scale = 0.6,
                hflip=true,
            };

            Button
            {
                rotate=true,
                name="scrollup",
                x=420,
                y=225,
                scale = 0.4
            };

            Button
            {
                graphics = LeftButtonGraphics,
                rotate=true,
                hflip=true,
                name="scrolldown",
                x=420,
                y=440,
                scale = 0.4
            };

            SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
            Button
            {
                x=20,
                y=kMax-50,
                name="back",
                flags = kHAlignCenter + kVAlignCenter,
                command =
                    function()
                        PopModal("hiscorescreen"); -- take off high score menu, restart game loop
                    end,
                SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
                CreateText(2,2,"back", 0, 0),
                SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
                CreateText(0,0,"back", 0, 0),
            };

            SetStyle(CreatePushButtonStyle(LongButtonGraphics, DefaultButtonSound)),
            Button
            {
                align=kHAlignRight, -- Position this button at its right edge
                x=kMax-20,-- With above align, position the right edge
                y=kMax-56,
                name="viewlocal",
                scale=1.1,
                SetStyle(CreateTextStyle(FontButtons, 24, WhiteColorAlpha128)),
                CreateText(2,2,"viewlocal",0,0),
		SetStyle(CreateTextStyle(FontButtons, 24, BlackColor)),
                CreateText(0,0,"viewlocal",0,0),
            };
            
            Button
            {
                align=kHAlignRight, -- Position this button at its right edge
                x=kMax-20,-- With above align, position the right edge
                y=kMax-56,
                name="view",
                scale=1.1,
                SetStyle(CreateTextStyle(FontButtons, 24, WhiteColorAlpha128)),
                CreateText(2,2,"viewglobal",0,0),
		SetStyle(CreateTextStyle(FontButtons, 24, BlackColor)),
                CreateText(0,0,"viewglobal",0,0),
            };
        }
    }
}